using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Configuration;
using System.Data;
using gov.va.med.vbecs.GUI.controls;

using DAILYQCWORKLIST = gov.va.med.vbecs.Common.VbecsTables.DailyQcWorklist;
namespace gov.va.med.vbecs.GUI
{

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Mike      </Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>9/23/2002</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	/// BR_2.02 This form is used to select an invoice that will be used to populate the worklist builder
	/// control with available blood units that need to be tested. 
	///</summary>
	public class FrmAboRHSelectInvoice : gov.va.med.vbecs.GUI.VbecsBaseForm
	{

		#region Form Controls

		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private gov.va.med.vbecs.GUI.controls.InvoiceSelectTool invoiceSelectTool1;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.Panel pnlRack;
		private System.Windows.Forms.GroupBox grpRackDate;
		private System.Windows.Forms.Label lblTestedBy;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbTestedBy;
		private System.Windows.Forms.DateTimePicker dtpDateTested;
		private System.Windows.Forms.Label lblDateTested;
		private System.Windows.Forms.GroupBox grpTestingMethod;
		private System.Windows.Forms.GroupBox grpRack;
		private System.Windows.Forms.ListView lvRacks;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.GroupBox grpAutomatedInstrument;
		private System.Windows.Forms.CheckBox cbInstrumentQCd;
		private System.Windows.Forms.TextBox txtInstrumentName;
		private System.Windows.Forms.Label lblInstrumentName;
		private System.Windows.Forms.CheckBox cbPerformAntiD;
		private System.Windows.Forms.CheckBox cbAutomatedInstrument;
		private System.ComponentModel.IContainer components;

		#endregion

		#region Variables

		private DataTable dtInvoices;
		private System.Guid _shipmentGuid;

		private bool _invoice;
		private DateTime _currentDate;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private bool _selectedRow;
		private string _automatedInstrName;
		private bool _automatedInstrQCd;
		private Guid _rackGuid;
		private bool _performAntiD;
		private string _rackNotQcComment = string.Empty;
		private System.Collections.ArrayList _userIds = new System.Collections.ArrayList();

		#endregion


		///<Developers>
		///	<Developer>Mike      </Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/23/2002</CreationDate>
		///
		///<summary> Constructor
		///</summary>
		public FrmAboRHSelectInvoice(bool invoice)
		{
			_invoice = invoice;
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
			//
			SetComponentProperties();
			//
			if (invoice == false)
			{
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC002.FrmAboRHSelectInvoice_Rack());
				this.pnlRack.BringToFront();
			}
			else
			{
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC002.FrmAboRHSelectInvoice());
				this.pnlRack.SendToBack();
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmAboRHSelectInvoice));
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.invoiceSelectTool1 = new gov.va.med.vbecs.GUI.controls.InvoiceSelectTool();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.pnlRack = new System.Windows.Forms.Panel();
			this.cbAutomatedInstrument = new System.Windows.Forms.CheckBox();
			this.grpRackDate = new System.Windows.Forms.GroupBox();
			this.lblTestedBy = new System.Windows.Forms.Label();
			this.cmbTestedBy = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.dtpDateTested = new System.Windows.Forms.DateTimePicker();
			this.lblDateTested = new System.Windows.Forms.Label();
			this.grpRack = new System.Windows.Forms.GroupBox();
			this.lvRacks = new System.Windows.Forms.ListView();
			this.columnHeader3 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
			this.grpAutomatedInstrument = new System.Windows.Forms.GroupBox();
			this.cbInstrumentQCd = new System.Windows.Forms.CheckBox();
			this.txtInstrumentName = new System.Windows.Forms.TextBox();
			this.lblInstrumentName = new System.Windows.Forms.Label();
			this.grpTestingMethod = new System.Windows.Forms.GroupBox();
			this.cbPerformAntiD = new System.Windows.Forms.CheckBox();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpImage.SuspendLayout();
			this.pnlRack.SuspendLayout();
			this.grpRackDate.SuspendLayout();
			this.grpRack.SuspendLayout();
			this.grpAutomatedInstrument.SuspendLayout();
			this.grpTestingMethod.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(488, 30);
			this.vbecsLogo1.TabIndex = 4;
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 269);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 6;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(408, 256);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.Size = new System.Drawing.Size(76, 23);
			this.btnCancel.TabIndex = 3;
			this.btnCancel.Text = "&Cancel";
			this.toolTip1.SetToolTip(this.btnCancel, "Click Cancel to discard changes and return");
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(4, 36);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 213);
			this.grpImage.TabIndex = 5;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.BackColor = System.Drawing.Color.Transparent;
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 7;
			this.pictureBox1.TabStop = false;
			// 
			// invoiceSelectTool1
			// 
			this.invoiceSelectTool1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.invoiceSelectTool1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.invoiceSelectTool1.IncomingShipment = false;
			this.invoiceSelectTool1.InvoiceListSource = null;
			this.invoiceSelectTool1.InvoiceListSourceAL = null;
			this.invoiceSelectTool1.Location = new System.Drawing.Point(60, 36);
			this.invoiceSelectTool1.Name = "invoiceSelectTool1";
			this.invoiceSelectTool1.Size = new System.Drawing.Size(424, 213);
			this.invoiceSelectTool1.TabIndex = 0;
			this.invoiceSelectTool1.UsingDataTable = true;
			this.invoiceSelectTool1.InvoiceSelected += new System.EventHandler(this.invoiceSelectTool1_InvoiceSelected);
			// 
			// pnlRack
			// 
			this.pnlRack.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlRack.Controls.Add(this.cbAutomatedInstrument);
			this.pnlRack.Controls.Add(this.grpRackDate);
			this.pnlRack.Controls.Add(this.grpRack);
			this.pnlRack.Controls.Add(this.grpAutomatedInstrument);
			this.pnlRack.Controls.Add(this.grpTestingMethod);
			this.pnlRack.Location = new System.Drawing.Point(60, 32);
			this.pnlRack.Name = "pnlRack";
			this.pnlRack.Size = new System.Drawing.Size(424, 220);
			this.pnlRack.TabIndex = 1;
			// 
			// cbAutomatedInstrument
			// 
			this.cbAutomatedInstrument.Location = new System.Drawing.Point(224, 72);
			this.cbAutomatedInstrument.Name = "cbAutomatedInstrument";
			this.cbAutomatedInstrument.Size = new System.Drawing.Size(172, 16);
			this.cbAutomatedInstrument.TabIndex = 2;
			this.cbAutomatedInstrument.Text = "&Using Automated Instrument";
			this.cbAutomatedInstrument.CheckedChanged += new System.EventHandler(this.cbAutomatedInstrument_CheckedChanged);
			// 
			// grpRackDate
			// 
			this.grpRackDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpRackDate.Controls.Add(this.lblTestedBy);
			this.grpRackDate.Controls.Add(this.cmbTestedBy);
			this.grpRackDate.Controls.Add(this.dtpDateTested);
			this.grpRackDate.Controls.Add(this.lblDateTested);
			this.grpRackDate.Location = new System.Drawing.Point(218, 4);
			this.grpRackDate.Name = "grpRackDate";
			this.grpRackDate.Size = new System.Drawing.Size(204, 64);
			this.grpRackDate.TabIndex = 1;
			this.grpRackDate.TabStop = false;
			// 
			// lblTestedBy
			// 
			this.lblTestedBy.Location = new System.Drawing.Point(8, 36);
			this.lblTestedBy.Name = "lblTestedBy";
			this.lblTestedBy.Size = new System.Drawing.Size(72, 20);
			this.lblTestedBy.TabIndex = 2;
			this.lblTestedBy.Text = "Tested By*";
			this.lblTestedBy.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cmbTestedBy
			// 
			this.cmbTestedBy.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbTestedBy.Interval = 100;
			this.cmbTestedBy.Location = new System.Drawing.Point(80, 36);
			this.cmbTestedBy.MaxLength = 50;
			this.cmbTestedBy.Name = "cmbTestedBy";
			this.cmbTestedBy.Size = new System.Drawing.Size(116, 22);
			this.cmbTestedBy.TabIndex = 3;
			this.cmbTestedBy.SelectedIndexChanged += new System.EventHandler(this.cmbTestedBy_Event);
			// 
			// dtpDateTested
			// 
			this.dtpDateTested.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpDateTested.CustomFormat = "MM/dd/yyyy HH:mm";
			this.dtpDateTested.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpDateTested.Location = new System.Drawing.Point(80, 10);
			this.dtpDateTested.Name = "dtpDateTested";
			this.dtpDateTested.Size = new System.Drawing.Size(116, 20);
			this.dtpDateTested.TabIndex = 1;
			this.dtpDateTested.ValueChanged += new System.EventHandler(this.dtpDateTested_ValueChanged);
			// 
			// lblDateTested
			// 
			this.lblDateTested.Location = new System.Drawing.Point(8, 12);
			this.lblDateTested.Name = "lblDateTested";
			this.lblDateTested.Size = new System.Drawing.Size(72, 20);
			this.lblDateTested.TabIndex = 0;
			this.lblDateTested.Text = "Date Tested*";
			this.lblDateTested.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpRack
			// 
			this.grpRack.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpRack.Controls.Add(this.lvRacks);
			this.grpRack.Location = new System.Drawing.Point(0, 4);
			this.grpRack.Name = "grpRack";
			this.grpRack.Size = new System.Drawing.Size(212, 212);
			this.grpRack.TabIndex = 0;
			this.grpRack.TabStop = false;
			this.grpRack.Text = "Reagent Rack*";
			// 
			// lvRacks
			// 
			this.lvRacks.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvRacks.CheckBoxes = true;
			this.lvRacks.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																					  this.columnHeader3,
																					  this.columnHeader1,
																					  this.columnHeader2});
			this.lvRacks.FullRowSelect = true;
			this.lvRacks.Location = new System.Drawing.Point(8, 16);
			this.lvRacks.MultiSelect = false;
			this.lvRacks.Name = "lvRacks";
			this.lvRacks.Size = new System.Drawing.Size(196, 188);
			this.lvRacks.TabIndex = 0;
			this.lvRacks.View = System.Windows.Forms.View.Details;
			this.lvRacks.SelectedIndexChanged += new System.EventHandler(this.lvRacks_SelectedIndexChanged);
			this.lvRacks.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvRacks_ItemCheck);
			// 
			// columnHeader3
			// 
			this.columnHeader3.Text = "";
			this.columnHeader3.Width = 30;
			// 
			// columnHeader1
			// 
			this.columnHeader1.Text = "Rack";
			// 
			// columnHeader2
			// 
			this.columnHeader2.Text = "Tested";
			this.columnHeader2.Width = 100;
			// 
			// grpAutomatedInstrument
			// 
			this.grpAutomatedInstrument.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpAutomatedInstrument.Controls.Add(this.cbInstrumentQCd);
			this.grpAutomatedInstrument.Controls.Add(this.txtInstrumentName);
			this.grpAutomatedInstrument.Controls.Add(this.lblInstrumentName);
			this.grpAutomatedInstrument.Enabled = false;
			this.grpAutomatedInstrument.Location = new System.Drawing.Point(218, 72);
			this.grpAutomatedInstrument.Name = "grpAutomatedInstrument";
			this.grpAutomatedInstrument.Size = new System.Drawing.Size(204, 80);
			this.grpAutomatedInstrument.TabIndex = 3;
			this.grpAutomatedInstrument.TabStop = false;
			// 
			// cbInstrumentQCd
			// 
			this.cbInstrumentQCd.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cbInstrumentQCd.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbInstrumentQCd.Location = new System.Drawing.Point(8, 56);
			this.cbInstrumentQCd.Name = "cbInstrumentQCd";
			this.cbInstrumentQCd.Size = new System.Drawing.Size(189, 20);
			this.cbInstrumentQCd.TabIndex = 2;
			this.cbInstrumentQCd.Text = "Instrument &QC\'d?*";
			this.cbInstrumentQCd.CheckedChanged += new System.EventHandler(this.cbInstrumentQCd_CheckedChanged);
			// 
			// txtInstrumentName
			// 
			this.txtInstrumentName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtInstrumentName.Location = new System.Drawing.Point(8, 32);
			this.txtInstrumentName.MaxLength = 50;
			this.txtInstrumentName.Name = "txtInstrumentName";
			this.txtInstrumentName.Size = new System.Drawing.Size(189, 20);
			this.txtInstrumentName.TabIndex = 1;
			this.txtInstrumentName.Text = "";
			this.txtInstrumentName.TextChanged += new System.EventHandler(this.txtInstrumentName_TextChanged);
			// 
			// lblInstrumentName
			// 
			this.lblInstrumentName.Location = new System.Drawing.Point(8, 16);
			this.lblInstrumentName.Name = "lblInstrumentName";
			this.lblInstrumentName.Size = new System.Drawing.Size(100, 20);
			this.lblInstrumentName.TabIndex = 0;
			this.lblInstrumentName.Text = "Instrument Name*";
			this.lblInstrumentName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpTestingMethod
			// 
			this.grpTestingMethod.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpTestingMethod.Controls.Add(this.cbPerformAntiD);
			this.grpTestingMethod.Location = new System.Drawing.Point(218, 156);
			this.grpTestingMethod.Name = "grpTestingMethod";
			this.grpTestingMethod.Size = new System.Drawing.Size(204, 60);
			this.grpTestingMethod.TabIndex = 4;
			this.grpTestingMethod.TabStop = false;
			this.grpTestingMethod.Text = "Testing Method";
			// 
			// cbPerformAntiD
			// 
			this.cbPerformAntiD.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cbPerformAntiD.Checked = true;
			this.cbPerformAntiD.CheckState = System.Windows.Forms.CheckState.Checked;
			this.cbPerformAntiD.Location = new System.Drawing.Point(8, 24);
			this.cbPerformAntiD.Name = "cbPerformAntiD";
			this.cbPerformAntiD.Size = new System.Drawing.Size(188, 20);
			this.cbPerformAntiD.TabIndex = 0;
			this.cbPerformAntiD.Text = "Perform Anti-&D Testing";
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(328, 256);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 2;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// FrmAboRHSelectInvoice
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(488, 285);
			this.Controls.Add(this.pnlRack);
			this.Controls.Add(this.invoiceSelectTool1);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.btnCancel);
			this.hlphelpChm.SetHelpKeyword(this, "ABO_Rh_Confirmation.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			
			this.MaximizeBox = false;
			this.MinimumSize = new System.Drawing.Size(496, 312);
			this.Name = "FrmAboRHSelectInvoice";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "VBECS - Unit ABO/Rh Confirmation";
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.invoiceSelectTool1, 0);
			this.Controls.SetChildIndex(this.pnlRack, 0);
			this.grpImage.ResumeLayout(false);
			this.pnlRack.ResumeLayout(false);
			this.grpRackDate.ResumeLayout(false);
			this.grpRack.ResumeLayout(false);
			this.grpAutomatedInstrument.ResumeLayout(false);
			this.grpTestingMethod.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Properties

		/// <summary>
		/// Get ShipmentGuid
		/// </summary>
		public System.Guid ShipmentGuid
		{
			get
			{
				return this._shipmentGuid;
			}
		}

		/// <summary>
		/// Get TestDateTime
		/// </summary>
		public DateTime TestDateTime
		{
			get
			{
				return this.dtpDateTested.Value;
			}
		}

		/// <summary>
		/// Get AutomatedInstrName
		/// </summary>
		public string AutomatedInstrName
		{
			get
			{
				return this._automatedInstrName;
			}
		}

		/// <summary>
		/// Get AutomatedInstrQCd
		/// </summary>
		public bool AutomatedInstrQCd
		{
			get
			{
				return this._automatedInstrQCd;
			}
		}

		/// <summary>
		/// Get RackGuid
		/// </summary>
		public Guid RackGuid
		{
			get
			{
				return this._rackGuid;
			}
		}

		/// <summary>
		/// Get TestUser
		/// </summary>
		public string TestUser
		{
			get
			{
				return this._userIds[this.cmbTestedBy.SelectedIndex].ToString();
			}
		}

		/// <summary>
		/// Get PerformAntiD
		/// </summary>
		public bool PerformAntiD
		{
			get
			{
				return this._performAntiD;
			}
		}

		/// <summary>
		/// Get RackNotQCComment
		/// </summary>
		public string RackNotQCComment
		{
			get
			{
				return this._rackNotQcComment;
			}
		}

		#endregion

		#region Methods

		/// <summary>
		/// This sets the properties for the invoice select control.
		/// </summary>
		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			this.vbecsLogo1.Title="Unit ABO/Rh Confirmation";
			invoiceSelectTool1.IncomingShipment = true;
			_currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();	
			this.dtpDateTested.Value = _currentDate;
			//BR_27.09
			if (this._invoice == true)
			{
				dtInvoices = BOL.IncomingShipment.GetShipmentsWithAvailableUnitsPastFiveDays ();
				invoiceSelectTool1.InvoiceListSource = dtInvoices;
			
				invoiceSelectTool1.Text = "Select Invoice*";
				this.RequiredFieldsLabel = false;
			}
			else
			{
				LoadRackList();
				LoadUserList();
				CheckForRequiredData();
			}
		}

		private void LoadRackList()
		{
			this.lvRacks.Items.Clear();

			DataTable dtRacks = BOL.Rack.GetDailyQCRacks(this.dtpDateTested.Value);
			foreach(DataRow drRack in dtRacks.Rows)
			{
				if (drRack.IsNull(DAILYQCWORKLIST.DailyUseIndicator) == false)
				{
					if( !(bool)drRack[DAILYQCWORKLIST.DailyUseIndicator] )
						continue;
				}
				
				ListViewItem lvItm = new ListViewItem();
				lvItm.SubItems.Add(drRack[Common.VbecsTables.Rack.RackName].ToString().Trim());

				if( !drRack.IsNull( DAILYQCWORKLIST.DailyQcExpirationDate ))
				{
					if ((bool)drRack[DAILYQCWORKLIST.PartiallyTestedIndicator] == false)
						lvItm.SubItems.Add("Yes");
					else
						lvItm.SubItems.Add("No");
				}
				else
				{
					lvItm.SubItems.Add("No");
				}
				
				lvItm.Tag = drRack;
				this.lvRacks.Items.Add(lvItm);
			}
		}

		private void LoadUserList()
		{
			System.Collections.ArrayList activeUsers = BOL.VbecsUser.GetActiveDivisionUsers(Common.LogonUser.LogonUserDivisionCode);

			//The _userIds arraylist will be in sync with the combobox's index
			foreach (BOL.VbecsUser curUser in activeUsers)
			{
				this.cmbTestedBy.Items.Add(curUser.UserName );
				this._userIds.Add(curUser.UserNTLoginID);
			}

			this.cmbTestedBy.SelectedItem = ThisUser.UserName;
		}

		/// <summary>
		/// Checks if the user entered all required data
		/// </summary>
		/// <returns></returns>
		private bool CheckForRequiredData()
		{
			string ToolTipMessage = "";

			if (this.lvRacks.CheckedItems.Count == 0)
			{
				ToolTipMessage += Common.StrRes.Tooltips.UC056.ChooseRack().ResString;
				ToolTipMessage += "\n";
			}

			if (this.cmbTestedBy.SelectedIndex == -1)
			{
				ToolTipMessage += Common.StrRes.Tooltips.UC056.ChooseTestedBy().ResString;
				ToolTipMessage += "\n";
			}

			if (this.cbAutomatedInstrument.Checked == true && (this.txtInstrumentName.Text.Trim() == "" || this.cbInstrumentQCd.Checked == false))
			{
				ToolTipMessage += Common.StrRes.Tooltips.UC056.EnterAutoInstrument().ResString;
				ToolTipMessage += "\n";
			}

			this.btnOK.SetToolTip(ToolTipMessage);

			return(ToolTipMessage == string.Empty);

		}

		#endregion

		#region Events
	
		/// <summary>
		/// Closes the form.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		/// <summary>
		/// Enables the OK button if an invoice is selected.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void invoiceSelectTool1_InvoiceSelected(object sender, System.EventArgs e)
		{
			btnOK.EnabledButton = true;
		}

		private void lvRacks_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (this.lvRacks.CheckedItems.Count > 0)
			{
				foreach(ListViewItem lvi in this.lvRacks.CheckedItems)
				{
					lvi.Checked = false;
				}
			}

			foreach(ListViewItem lvi in ((ListView)sender).SelectedItems)
			{
				_selectedRow = true;
				lvi.Checked = true;
			}

			this.btnOK.EnabledButton = this.CheckForRequiredData();
		}

		private void lvRacks_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			if (e.NewValue == CheckState.Checked)
			{
				if (this.lvRacks.CheckedItems.Count > 0)
				{
					foreach(ListViewItem lvi in this.lvRacks.CheckedItems)
					{
						lvi.Checked = false;
					}
				}
				if (_selectedRow == false)
				{
					this.lvRacks.Items[e.Index].Selected = true;
				}
				else
				{
					_selectedRow = false;
				}
			}
			else
			{
				this.lvRacks.Items[e.Index].Selected = false;
			}

			this.btnOK.EnabledButton =  this.CheckForRequiredData();
		}

		private void dtpDateTested_ValueChanged(object sender, System.EventArgs e)
		{
			if (this.dtpDateTested.Value > _currentDate)
			{
				this.dtpDateTested.Value = _currentDate;
			}

			this.LoadRackList();	
			this.btnOK.EnabledButton =  this.CheckForRequiredData();
		}

		private void cbAutomatedInstrument_CheckedChanged(object sender, System.EventArgs e)
		{
			this.grpAutomatedInstrument.Enabled = ((CheckBox)sender).Checked;
			
			this.btnOK.EnabledButton =  this.CheckForRequiredData();

		}

		private void cmbTestedBy_Event(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton =  this.CheckForRequiredData();

		}

		private void txtInstrumentName_TextChanged(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton =  this.CheckForRequiredData();
		}

		private void cbInstrumentQCd_CheckedChanged(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton =  this.CheckForRequiredData();
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this._rackNotQcComment = string.Empty;
			bool qcOffline = false;

			if (this._invoice == true)
			{
				BOL.OutgoingShipmentCollection _Invoice = invoiceSelectTool1.SelectedInvoice;
				_shipmentGuid = _Invoice.ShipmentGuid;
				this.pnlRack.BringToFront();
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC002.FrmAboRHSelectInvoice_Rack());
				this._invoice = false;
				this.btnOK.EnabledButton = false;
				LoadRackList();
				LoadUserList();
				CheckForRequiredData();
			}
			else
			{
				DataRow drRack = null;
				bool RackNotTested = false;

				//Only one Rack can be checked at a time
				foreach(ListViewItem lvItm in this.lvRacks.CheckedItems)
				{
					drRack = (DataRow)lvItm.Tag;
				}

                //CR 3554
                if (drRack == null)
                    throw new ApplicationException("Rack is not found"); //Carrie123

				_rackGuid = (Guid)drRack[Common.VbecsTables.Rack.RackGuid];

				//CR 2718 - skip check for BR_41.30 if QC was done Offline
				if (drRack.IsNull(Common.VbecsTables.DailyQcWorklist.QCOfflineIndicator) == false)
				{
					if ((bool)drRack[Common.VbecsTables.DailyQcWorklist.QCOfflineIndicator] == true)
						qcOffline = true;
				}

				if (qcOffline == false)
				{
					//BR_41.30
					DataTable dt = BOL.Reagent.GetReagentFromRack(_rackGuid,(int)Common.ReagentType.AntiA, Common.LogonUser.LogonUserDivisionCode);
					if (dt.Rows.Count == 0)
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(Common.StrRes.Tooltips.Common.RackNotConfigured().ResString));
						return;
					}
				}


				if (drRack.IsNull(DAILYQCWORKLIST.DailyQcExpirationDate) == false)
				{
					if (((DateTime)drRack[DAILYQCWORKLIST.DailyQcExpirationDate]).Date < _currentDate.Date)
					{
						RackNotTested = true;
					}
				}
				else
				{
					RackNotTested = true;
				}

				if (RackNotTested == true)
				{
					DlgOverrideComment dlg = new DlgOverrideComment("QC not performed", "Rack QC not performed. Continue to use?", "PT");
					if (dlg.ShowDialog(this) == DialogResult.Cancel)
					{
						return;
					}
					else
					{
						//create exception here
						this._rackNotQcComment = dlg.Comment;
					}
				}

				if (this.cbAutomatedInstrument.Checked)
				{
					_automatedInstrName = this.txtInstrumentName.Text.Trim();
				}
				else
				{
					_automatedInstrName = "";
				}

				_automatedInstrQCd = this.cbInstrumentQCd.Checked;

				this._performAntiD =  this.cbPerformAntiD.Checked;

				this.DialogResult = DialogResult.OK;
				this.Close();
			}		
		}

		#endregion

	}
}
